<?php
require_once(__DIR__ . '/GatewaySetting.php');
require_once(__DIR__ . '/utility.php');

function parseSetupNatArg($argv, &$dhcp_enabled, &$sc_id, &$ip, &$mask, &$gateway, &$dns)
{
    if (count($argv) < 2) {
        echo "Usage: cluster_setup_nat_network CLUSTER_ID DHCP IP MASK GATEWAY DNS\n";
        exit(1);
    }

    $dhcp_enabled = $argv[1];
    if (!$dhcp_enabled) {
        if (count($argv) != 6) {
            echo "Usage: cluster_setup_nat_network CLUSTER_ID DHCP IP MASK GATEWAY DNS\n";
            exit(1);
        }
    }

    $sc_id = $argv[0];
    $ip = $dhcp_enabled ? "" : $argv[2];
    $mask = $dhcp_enabled ? "" : $argv[3];
    $gateway = $dhcp_enabled ? "" : $argv[4];
    $dns = $dhcp_enabled ? "" : $argv[5];
}

function cluster_setup_nat_network($argv)
{
    global $DTASCFG_XML_FILE, $CLUSTER_DTASCFG_XML_FILE;
    $isDHCP = $sc_id = $ip = $mask = $gateway = $dns = null;
    parseSetupNatArg($argv, $isDHCP, $sc_id, $ip, $mask, $gateway, $dns);
    try {
        $cluster_cfg_retriever = new ClusterConfigRetriever($DTASCFG_XML_FILE);
        $cluster_cfg_retriever->getClusterConfig($sc_id, $CLUSTER_DTASCFG_XML_FILE);
        $cluster_gateway_retriever = new GatewayRetriever($CLUSTER_DTASCFG_XML_FILE);
        $cluster_gateway = $cluster_gateway_retriever->getGateway();
        if ($isDHCP) $ret = $cluster_gateway->setDHCP();
        else $ret = $cluster_gateway->setStatic($ip, $mask, $gateway, $dns);
        if(!$ret) throw new Exception("Cannot set network settings by isDHCP:$isDHCP, ip:$ip,
            mask:$mask, gateway:$gateway, dns:$dns");
        $gateway_info = $cluster_gateway->getGatewayInfo();
    } catch (Exception $e) {
        debug_print("Catch exception while setup cluster's network, " . var_export($e, true));
        $msg = $e->getMessage();
        echo "$msg";
        exit(1);
    }
    $ip = $gateway_info->getIP();
    $mask = $gateway_info->getMask();
    $gateway = $gateway_info->getGateway();
    $dns = $gateway_info->getFirstDns();
    echo "$ip $mask $gateway $dns";
}